<?php
	/*******************************************************************************
	 *
	 * File:         $Id$
	 * Modified_On:  $Date$
	 * Modified_By:  $Author$
	 * License:      GPLv2
	 * Copyright:    Copyright 2009-2014 by Urban-Software.de / Thomas Urban
	 *******************************************************************************/

	function plugin_nmidDeviceGrouping_install()
	{
		api_plugin_register_hook( 'nmidDeviceGrouping', 'api_device_save', 'nmidDeviceGrouping_api_device_save', 'setup.php' );
		api_plugin_register_hook( 'nmidDeviceGrouping', 'config_arrays', 'nmidDeviceGrouping_config_arrays', 'setup.php' );
		api_plugin_register_hook( 'nmidDeviceGrouping', 'config_form', 'nmidDeviceGrouping_config_form', 'setup.php' );
		api_plugin_register_hook( 'nmidDeviceGrouping', 'console_after', 'nmidDeviceGrouping_console_after', 'setup.php' );

		nmidDeviceGrouping_setup_table_new();
	}

	function nmidDeviceGrouping_console_after()
	{
		global $plugins, $config;
		nmidDeviceGrouping_check_upgrade();
		return TRUE;
	}

	function nmidDeviceGrouping_check_dependencies()
	{
		global $plugins, $config;

		return TRUE;
	}


	function plugin_nmidDeviceGrouping_check_config()
	{
		// Here we will check to ensure everything is configured
		nmidDeviceGrouping_check_upgrade();

		return TRUE;
	}

	function plugin_nmidDeviceGrouping_upgrade()
	{
		// Here we will upgrade to the newest version
		nmidDeviceGrouping_check_upgrade();
		return FALSE;
	}

	function plugin_nmidDeviceGrouping_version()
	{
		return nmidDeviceGrouping_version();
	}

	function nmidDeviceGrouping_check_upgrade()
	{
		$current = nmidDeviceGrouping_version();
		$current = $current[ 'version' ];
		$old     = db_fetch_cell( "SELECT version FROM plugin_config WHERE directory='nmidDeviceGrouping'" );
		if ( $current != $old ) {
			nmidDeviceGrouping_setup_table( $old );
		}

	}

	function nmidDeviceGrouping_config_form()
	{
		global $fields_host_edit;

		$fields_host_edit2 = $fields_host_edit;
		$fields_host_edit3 = array();
		// Check for available ReportEngines
		$ar_DeviceSites = db_fetch_assoc('SELECT DISTINCT nmid_devicegrouping_site FROM host;');

		foreach ( $fields_host_edit2 as $f => $a ) {
			if ( $f == 'availability_header' ) {
				$fields_host_edit3[ "nmid_devicegrouping_header" ]       = array(
						"method"        => "spacer",
						"friendly_name" => "NMID Grouping"
				);
				$fields_host_edit3[ "nmid_devicegrouping_site" ]     = array(
						"method"        => "textbox",
						"friendly_name" => 'Site',
						"description"   => 'Site of the device.',
						"value"         => "|arg1:nmid_devicegrouping_site|",
						"max_length"    => 255,
				);
			}
			$fields_host_edit3[ $f ] = $a;

		}
		$fields_host_edit = $fields_host_edit3;
	}

	function nmidDeviceGrouping_api_device_save( $save )
	{

		if ( isset( $_POST[ 'nmid_devicegrouping_site' ] ) ) {
			if ( strlen( $_POST[ 'nmid_devicegrouping_site' ] ) > 0 ) {
				$save[ "nmid_devicegrouping_site" ] = form_input_validate( $_POST[ 'nmid_devicegrouping_site' ], "nmid_devicegrouping_site", "", TRUE, 10 );
			}
		}
		else {
			$save[ 'nmid_devicegrouping_site' ] = form_input_validate( '', "nmid_devicegrouping_site", "", TRUE, 10 );
		}


		return $save;
	}

	function nmidDeviceGrouping_setup_table_new()
	{
		global $config, $database_default;
		include_once( $config[ "library_path" ] . "/database.php" );

		// Check if the CereusReporting tables are present
		$s_sql = 'show tables from `' . $database_default . '`';
		$result = db_fetch_assoc( $s_sql ) or die ( mysql_error() );
		$a_tables = array();

		$sql = array();

		foreach ( $result as $index => $array ) {
			foreach ( $array as $table ) {
				$a_tables[ ] = $table;
			}
		}

		api_plugin_db_add_column( 'nmidDeviceGrouping', 'host', array( 'name' => 'nmid_devicegrouping_site',
		                                                          'type' => 'varchar(1024)',
		                                                          'NULL' => TRUE, 'default' => '' ) );
	}

	function nmidDeviceGrouping_version()
	{
		return array( 'name'     => 'nmidDeviceGrouping',
		              'version'  => '1.11',
		              'longname' => 'NMID Device Grouping Addon',
		              'author'   => 'Thomas Urban',
		              'homepage' => 'http://blog.network-outsourcing.de/',
		              'email'    => 'support@urban-software.de',
		              'url'      => 'http://blog.network-outsourcing.de/versions.php'
		);
	}

	function nmidDeviceGrouping_setup_table( $old_version )
	{
		global $config;
		$dir = dirname( __FILE__ );

		// nmidDeviceGrouping_setup_table_new();
		$version_info = nmidDeviceGrouping_version();
		db_execute( 'UPDATE plugin_config SET version = "' . $version_info[ 'version' ] . '" WHERE directory = "nmidDeviceGrouping"' );


		// get minor and major version number
		preg_match( "@(\d+)\.(\d+).(\d+)@", $old_version, $version_match );

		$version_major = $version_match[ 1 ];
		$version_minor = $version_match[ 2 ];
		$version_build = $version_match[ 3 ];

		// Version 0.xx
		if ( $version_major < 1 ) {
			if ( $version_minor < 7 ) {
				//
			}
			if ( $version_minor < 10 ) {
				//
			}
		}
	}
