<?php
    /*******************************************************************************
     *
     * File:         $Id: CereusReporting_Availability_addDowntimeSchedule.php,v 6de4bc63a72b 2017/11/01 15:05:58 thurban $
     * Modified_On:  $Date: 2017/11/01 15:05:58 $
     * Modified_By:  $Author: thurban $
     * Language:     Perl
     * Encoding:     UTF-8
     * Status:       -
     * License:      Commercial
     * Copyright:    Copyright 2009/2010 by Urban-Software.de / Thomas Urban
     *******************************************************************************/

    include_once( 'functions.php' );
    $dir     = dirname( __FILE__ );
    $mainDir = preg_replace( "@plugins.CereusTransporter@", "", $dir );
    chdir( $mainDir );
    include( "./include/auth.php" );
    $_SESSION[ 'custom' ] = FALSE;

    /* set default action */
    if ( !isset( $_REQUEST[ "drp_action" ] ) ) {  $_REQUEST[ "drp_action" ] = ""; }
    if ( !isset( $_REQUEST[ "sort_column" ] ) ) { $_REQUEST[ "sort_column" ] = ""; }
    if ( !isset( $_REQUEST[ "sort_direction" ] ) ) { $_REQUEST[ "sort_direction" ] = ""; }

    // Check input data
    $_REQUEST[ "drp_action" ]    = filter_var( $_REQUEST[ "drp_action" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "sort_column" ]    = filter_var( $_REQUEST[ "sort_column" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "sort_direction" ]    = filter_var( $_REQUEST[ "sort_direction" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );


    switch ( $_REQUEST[ "action" ] ) {
        case 'save':
            form_save( $_REQUEST[ "target_id" ] );
            break;
        default:
            top_header();
            form_display( $_REQUEST[ "target_id" ] );
            bottom_footer();
            break;
    }

    function form_delete()
    {
        global $colors, $hash_type_names;

        /* loop through each of the selected tasks and delete them*/
        foreach ( $_POST as $var => $val) {
            if ( preg_match( "/^chk_([0-9]+)$/", $var, $matches ) ) {
                /* ================= input validation ================= */
                input_validate_input_number( $matches[ 1 ] );
                /* ==================================================== */
                // CRC-6 Deleting a report does not delete associated schedule
                db_execute( "DELETE FROM `plugin_CereusTransporter_filter` where `filterId`='" . $matches[ 1 ] . "'" );
            }
        }
        header( "Location: CereusTransporter_Filters.php" );
    }

    function form_edit()
    {

    }

    function form_display() {
        global $colors, $config;
        print "<font size=+1>CereusTransporter - Filters</font><br>\n";
        print "<hr>\n";

        $username = db_fetch_cell( "select username from user_auth where id=" . $_SESSION[ "sess_user_id" ] );

        $where_clause = '';
        if ( isset( $_REQUEST[ "sort_column" ] ) ) {
            if (
                ( $_REQUEST[ "sort_column" ] == 'FilterID' )
                || ( $_REQUEST[ "sort_column" ] == 'Name' )
                || ( $_REQUEST[ "sort_column" ] == 'Description' )
            ) {
                if (
                    ( $_REQUEST[ "sort_direction" ] == 'ASC' )
                    || ( $_REQUEST[ "sort_direction" ] == 'DESC' )
                ) {
                    $where_clause .= ' ORDER BY ' .
                        $_REQUEST[ "sort_column" ] .
                        ' ' . $_REQUEST[ "sort_direction" ];
                }
            }
        }
        $a_filters = db_fetch_assoc( "
            SELECT
              `plugin_CereusTransporter_filter`.`filterId`,
              `plugin_CereusTransporter_filter`.`filter_name`,
              `plugin_CereusTransporter_filter`.`filter_description`,
              `plugin_CereusTransporter_filter`.`filter_active`,
              `plugin_CereusTransporter_filter_type`.`filter_type_name` 
            FROM
              `plugin_CereusTransporter_filter` INNER JOIN
              `plugin_CereusTransporter_filter_type` ON `plugin_CereusTransporter_filter_type`.`filter_type_id`
                = `plugin_CereusTransporter_filter_type`.`filterTypeId`;
        " );

        print "<form name=chk method=POST action=CereusTransporter_Filter.php>\n";

        html_start_box( "<strong>CereusTransporter  - Filters</strong>", "100%", htmlspecialchars( $colors[ "header" ] ), "3", "center", "CereusTransporter_addFilter.php?action=add" );

        form_hidden_box( "save_component_import", "1", "" );

        if (sizeof( $a_filters ) > 0) {

            $menu_text = array(
                //"ID" => array("filterId", "ASC"),
                "filter_name"        => array( "Name", "ASC" ),
                "filter_description" => array( "Description", "ASC" ),
                "filter_type_name"  => array( "Type", "ASC" ),
                "filter_active"  => array( "is Active", "ASC" )
            );

            html_header_sort_checkbox( $menu_text, $_REQUEST[ "sort_column" ], $_REQUEST[ "sort_direction" ] );
            $limit = 100;
            foreach ($a_filters as $a_filter)
            {
                $description = $a_filter[ 'Description' ];
                $description = preg_replace( "/<br>/", "", $description );
                if ( strlen( $description ) > $limit ) {
                    $description = substr( $description, 0, strrpos( substr( $description, 0, $limit ), ' ' ) ) . '...';
                }
                $description = htmlspecialchars( $description );

                form_alternate_row('line' . $a_filter[ 'filterId' ], true);
                form_selectable_cell( "<a href='" . $config[ 'url_path' ] . "plugins/CereusTransporter/CereusTransporter_addFilter.php?action=update&filterId=" . $a_filter[ "filterId" ] . "'><img style='border:0px' src='" . $config[ 'url_path' ] . "plugins/CereusTransporter/images/Report.png'/><b>" . htmlspecialchars( $a_filter[ 'Name' ] ) . "</b></a>", $a_filter[ 'filterId' ], 250 );
                form_selectable_cell( $description, $a_filter[ "filterId" ] );
                form_selectable_cell( $a_filter[ 'filter_type_name' ], $a_filter[ "filterId" ] );
                form_selectable_cell( $a_filter[ 'filter_active' ], $a_filter[ "filterId" ] );
                form_checkbox_cell( 'selected_items', $a_filter[ "filterId" ] );
                form_end_row();
            }
            html_end_box( FALSE );

            $task_actions = array(
                1 => "Please select an action",
                2 => "Delete"
            );
            draw_actions_dropdown( $task_actions );
        } else {
            print "<tr>
                    <td><em>No Filter exist</em></td>
                   </tr>";
            html_end_box( FALSE );
        }
        print "</form>";
    }
