<?php
    /*******************************************************************************
     *
     * File:         $Id: CereusReporting_Reports.php,v ea43511c66ce 2018/11/11 17:22:55 thurban $
     * Modified_On:  $Date: 2018/11/11 17:22:55 $
     * Modified_By:  $Author: thurban $
     * Language:     Perl
     * Encoding:     UTF-8
     * Status:       -
     * License:      Commercial
     * Copyright:    Copyright 2009/2010 by Urban-Software.de / Thomas Urban
     *******************************************************************************/

    include_once( 'functions.php' );

    $dir = __DIR__;
    $mainDir = preg_replace( "@plugins.CereusTransporter@", "", $dir );
    chdir( $mainDir );
    include( "./include/auth.php" );
    $_SESSION[ 'custom' ] = FALSE;

    /* set default action */
    if ( !isset( $_REQUEST[ "drp_action" ] ) ) {  $_REQUEST[ "drp_action" ] = ""; }
    if ( !isset( $_REQUEST[ "sort_column" ] ) ) { $_REQUEST[ "sort_column" ] = ""; }
    if ( !isset( $_REQUEST[ "sort_direction" ] ) ) { $_REQUEST[ "sort_direction" ] = ""; }

    // Check input data
    $_REQUEST[ "drp_action" ]    = filter_var( $_REQUEST[ "drp_action" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "sort_column" ]    = filter_var( $_REQUEST[ "sort_column" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "sort_direction" ]    = filter_var( $_REQUEST[ "sort_direction" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );

    switch ( $_REQUEST[ "drp_action" ] ) {
        case '2':
            form_delete();
            break;
        default:
            top_header();
            form_display();
            bottom_footer();
            break;
    }

    function form_delete()
    {
        global $colors, $hash_type_names;

        /* loop through each of the selected tasks and delete them*/
        foreach ( $_POST as $var => $val) {
            if ( preg_match( "/^chk_([0-9]+)$/", $var, $matches ) ) {
                /* ================= input validation ================= */
                input_validate_input_number( $matches[ 1 ] );
                /* ==================================================== */
                // CRC-6 Deleting a report does not delete associated schedule
                db_execute( "DELETE FROM `plugin_CereusTransporter_targets` where `target_id`='" . $matches[ 1 ] . "'" );
            }
        }
        header( "Location: CereusTransporter_Targets.php" );
    }

    function form_edit()
    {

    }

    function form_display() {
        global $colors, $config;
        print "<font size=+1>CereusTransporter - Targets</font><br>\n";
        print "<hr>\n";

        $username = db_fetch_cell( "select username from user_auth where id=" . $_SESSION[ "sess_user_id" ] );

        $where_clause = '';
        if ( isset( $_REQUEST[ "sort_column" ] ) ) {
            if (
                ( $_REQUEST[ "sort_column" ] == 'TargetID' )
                || ( $_REQUEST[ "sort_column" ] == 'Name' )
                || ( $_REQUEST[ "sort_column" ] == 'Description' )
            ) {
                if (
                    ( $_REQUEST[ "sort_direction" ] == 'ASC' )
                    || ( $_REQUEST[ "sort_direction" ] == 'DESC' )
                ) {
                    $where_clause .= ' ORDER BY ' .
                        $_REQUEST[ "sort_column" ] .
                        ' ' . $_REQUEST[ "sort_direction" ];
                }
            }
        }
        $a_targets = db_fetch_assoc( "
            SELECT
              `plugin_CereusTransporter_targets`.`target_id`,
              `plugin_CereusTransporter_targets`.`target_name`,
              `plugin_CereusTransporter_targets`.`target_description`,
              `plugin_CereusTransporter_targets`.`target_active`,
              `plugin_CereusTransporter_targets_type`.`targets_type_name` 
            FROM
              `plugin_CereusTransporter_targets` INNER JOIN
              `plugin_CereusTransporter_targets_type` ON `plugin_CereusTransporter_targets_type`.`targets_type_id`
                = `plugin_CereusTransporter_targets_type`.`targetsTypeId`;
        " );

        print '<form name=chk method=POST action="CereusTransporter_Targets.php">';

        html_start_box( "<strong>CereusTransporter  - Targets</strong>", "100%", htmlspecialchars( $colors[ "header" ] ), "3", "center", "CereusTransporter_addTarget.php?action=add" );

        form_hidden_box( "save_component_import", "1", "" );

        if (sizeof( $a_targets ) > 0) {

            $menu_text = array(
                //"ID" => array("targetId", "ASC"),
                "target_name"        => array( "Name", "ASC" ),
                "target_description" => array( "Description", "ASC" ),
                "target_type_name"  => array( "Type", "ASC" ),
                "target_active"  => array( "is Active", "ASC" )
            );

            html_header_sort_checkbox( $menu_text, $_REQUEST[ "sort_column" ], $_REQUEST[ "sort_direction" ] );
            $limit = 100;
            foreach ($a_targets as $a_target)
            {
                $description = $a_target[ 'Description' ];
                $description = preg_replace( "/<br>/", "", $description );
                if ( strlen( $description ) > $limit ) {
                    $description = substr( $description, 0, strrpos( substr( $description, 0, $limit ), ' ' ) ) . '...';
                }
                $description = htmlspecialchars( $description );

                form_alternate_row('line' . $a_target[ 'targetId' ], true);
                form_selectable_cell( "<a href='" . $config[ 'url_path' ] . "plugins/CereusTransporter/CereusTransporter_addTarget.php?action=update&targetId=" . $a_target[ "targetId" ] . "'><img style='border:0px' src='" . $config[ 'url_path' ] . "plugins/CereusTransporter/images/Report.png'/><b>" . htmlspecialchars( $a_target[ 'Name' ] ) . "</b></a>", $a_target[ 'targetId' ], 250 );
                form_selectable_cell( $description, $a_target[ "targetId" ] );
                form_selectable_cell( $a_target[ 'target_type_name' ], $a_target[ "targetId" ] );
                form_selectable_cell( $a_target[ 'target_active' ], $a_target[ "targetId" ] );
                form_checkbox_cell( 'selected_items', $a_target[ "targetId" ] );
                form_end_row();
            }
            html_end_box( FALSE );

            $task_actions = array(
                1 => "Please select an action",
                2 => "Delete"
            );
            draw_actions_dropdown( $task_actions );
        } else {
            print "<tr>
                <td><em>No Target exist</em></td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                </tr>";
            html_end_box( FALSE );
        }
        print "</form>";
    }
