<?php
    /*******************************************************************************
     *
     * File:         $Id: CereusReporting_Availability_addDowntimeSchedule.php,v 6de4bc63a72b 2017/11/01 15:05:58 thurban $
     * Modified_On:  $Date: 2017/11/01 15:05:58 $
     * Modified_By:  $Author: thurban $
     * Language:     Perl
     * Encoding:     UTF-8
     * Status:       -
     * License:      Commercial
     * Copyright:    Copyright 2009/2010 by Urban-Software.de / Thomas Urban
     *******************************************************************************/

    include_once( 'functions.php' );
    $dir     = dirname( __FILE__ );
    $mainDir = preg_replace( "@plugins.CereusTransporter@", "", $dir );
    chdir( $mainDir );
    include( "./include/auth.php" );
    $_SESSION[ 'custom' ] = FALSE;

    /* set default action */
    if ( !isset( $_REQUEST[ "target_id" ] ) ) {
        $_REQUEST[ "target_id" ] = "";
    }
    if ( !isset( $_REQUEST[ "action" ] ) ) {
        $_REQUEST[ "action" ] = "";
    }


    // Check input data
    $_REQUEST[ "target_id" ]          = filter_var( $_REQUEST[ "target_id" ], FILTER_SANITIZE_NUMBER_INT );
    $_REQUEST[ "action" ]             = filter_var( $_REQUEST[ "action" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "target_name" ]        = filter_var( $_REQUEST[ "target_name" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "target_description" ] = filter_var( $_REQUEST[ "target_description" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "targets_type_id" ]    = filter_var( $_REQUEST[ "targets_type_id" ], FILTER_SANITIZE_NUMBER_INT );
    $_REQUEST[ "target_active" ]      = filter_var( $_REQUEST[ "target_active" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "target_host" ]        = filter_var( $_REQUEST[ "target_host" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
    $_REQUEST[ "target_port" ]        = filter_var( $_REQUEST[ "target_port" ], FILTER_SANITIZE_NUMBER_INT );
    $_REQUEST[ "target_url" ]         = filter_var( $_REQUEST[ "target_url" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );


    switch ( $_REQUEST[ "action" ] ) {
        case 'save':
            form_save( $_REQUEST[ "target_id" ] );
            break;
        default:
            top_header();
            form_display( $_REQUEST[ "target_id" ] );
            bottom_footer();
            break;
    }

    /**
     * Save and update database entires based on form data
     *
     * @param int $target_id
     *
     * @return void
     */
    function form_save( $target_id )
    {
        global $colors, $hash_type_names;

        // Check validitiy of data.
        if ( $target_id != "" ) {
            if ( isNumber( $target_id ) == FALSE ) {
                return;
            }
        }
        if ( isset ( $_POST[ 'target_id' ] ) ) {
            $target_id = filter_var( $_REQUEST[ "target_id" ], FILTER_SANITIZE_NUMBER_INT );
        }
        if ( isset ( $_POST[ 'target_name' ] ) ) {
            $s_dataChangeTypeId = filter_var( $_REQUEST[ "target_name" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
        }
        if ( isset ( $_POST[ 'target_description' ] ) ) {
            $s_dataShortDescription = filter_var( $_REQUEST[ "target_description" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
        }
        if ( isset ( $_POST[ 'targets_type_id' ] ) ) {
            $s_dataLongDescription = filter_var( $_REQUEST[ "targets_type_id" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH );
        }
        if ( isset ( $_POST[ 'target_active' ] ) ) {
            $s_dataStartTime = strtotime( filter_var( $_REQUEST[ "target_active" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH ) );
        }
        if ( isset ( $_POST[ 'endtime' ] ) ) {
            $s_dataEndTime = strtotime( filter_var( $_REQUEST[ "endtime" ], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_ENCODE_HIGH ) );
        }

        if ( ( isset ( $_POST[ 'shortDescription' ] ) ) && ( isset ( $_POST[ 'save_component_import' ] ) ) ) {
            db_execute( "
			INSERT INTO `plugin_nmidCreatePDF_Availability_Change_Table`
				(`deviceId`, `changeTypeId`, `shortDescription`,`longDescription`, `startTimeStamp`, `endTimeStamp`)
			VALUES
				($s_dataDeviceId, '$s_dataChangeTypeId','$s_dataShortDescription', '$s_dataLongDescription',
				'$s_dataStartTime', '$s_dataEndTime')
			" );
        }
        if ( ( isset ( $_POST[ 'shortDescription' ] ) ) && ( isset ( $_POST[ 'update_component_import' ] ) ) ) {
            db_execute( "
			UPDATE `plugin_nmidCreatePDF_Availability_Change_Table`
			Set
				deviceId=$s_dataDeviceId,
				changeTypeId='$s_dataChangeTypeId',
				shortDescription='$s_dataShortDescription',
				longDescription='$s_dataLongDescription',
				startTimeStamp='$s_dataStartTime',
				endTimeStamp='$s_dataEndTime'
			WHERE
				Id='$target_id'
			" );
        }
        header( "Location: CereusTransporter_Targets.php" );

    }

    /**
     * @param $target_id integer
     *
     * @return void
     */
    function form_display( $target_id )
    {
        global $colors, $hash_type_names, $config;

        $i_defaultDeviceId              = 0;
        $i_defaultChangeTypeId          = 0;
        $i_defaultStartTimeStamp        = time() - 3600;
        $i_defaultEndTimeStamp          = time();
        $s_defaultShortDescription      = '';
        $s_defaultLongDescription       = '';
        $i_defaultChangeWinServiceId    = 0;
        $i_defaultChangeTypeRecurringId = 0;
        $dateFormat                     = read_config_option( "nmid_pdf_dateformat" );

        if ( $target_id > 0 ) {
            $a_reports = db_fetch_assoc( "
			SELECT
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`deviceId`,
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`changeTypeId`,
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`startTimeStamp`,
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`endTimeStamp`,
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`shortDescription`,
			  `plugin_nmidCreatePDF_Availability_Change_Table`.`longDescription`
			FROM
			  `plugin_nmidCreatePDF_Availability_Change_Table`
			WHERE Id='$target_id'
		" );
            foreach ( $a_reports as $s_report ) {
                $target_id                   = $s_report[ 'target_id' ];
                $s_defaultTargetName         = $s_report[ 'target_name' ];
                $s_defaultTargetDescription  = $s_report[ 'target_description' ];
                $s_defaultTargetType         = $s_report[ 'targets_type_id' ];
                $s_defaultTargetActive       = $s_report[ 'target_active' ]; // 1 = true/enabled
                $s_defaultTargetHost         = $s_report[ 'target_host' ];
                $s_defaultTargetPort         = $s_report[ 'target_port' ];
                $s_defaultTargetURL          = $s_report[ 'target_url' ];
            }
        }

        print "<font size=+1>CereusTransporter - Add Target</font><br>\n";
        print "<hr>\n";

        ?>
        <form method="post" action="CereusTransporter_addTarget.php" enctype="multipart/form-data">
        <?php

        if ( $target_id > 0 ) {
            html_start_box( "<strong>CereusTransporter Target</strong> [update]", "100%", $colors[ "header" ], "3", "center", "" );
        } else {
            html_start_box( "<strong>CereusTransporter Target</strong> [new]", "100%", $colors[ "header" ], "3", "center", "" );
        }

        form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
            <td width="50%">
                <font class="textEditTitle">Target Name</font><br>
                The name of the target this data will be sent to .
            </td>
            <td>
                <?php form_text_box( "target_name", "", $s_defaultTargetName, 255 ); ?>
            </td>
        </tr>


        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
            <td width="50%">
                <font class="textEditTitle">Description</font><br>
                A description for this target
            </td>
            <td>
                <?php form_text_box( "target_description", "", $s_defaultTargetDescription, 255 ); ?>
            </td>
        </tr>

        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 1 ); ?>
            <td width="50%">
                <font class="textEditTitle">Target Type</font><br>
                The type of the target.
            </td>
            <td>
                <?php form_text_box( "target_type_id", "", $s_defaultTargetType, 255 ); ?>
            </td>
        </tr>

        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
            <td width="50%">
                <font class="textEditTitle">Is Target Active ?</font><br>
                Enable this target.
            </td>
            <td>
                <?php form_text_box( "target_active", "", $s_defaultTargetActive, 255 ); ?>
            </td>
        </tr>

        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
        <td width="50%">
            <font class="textEditTitle">Target Host/IP</font><br>
            The Hostname/IP of the target
        </td>
        <td>
            <?php form_text_box( "target_host", "", $s_defaultTargetHost, 255 ); ?>
        </td>
        </tr>

        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
        <td width="50%">
            <font class="textEditTitle">Target Port</font><br>
            The Port of the target
        </td>
        <td>
            <?php form_text_box( "target_port", "", $s_defaultTargetPort, 255 ); ?>
        </td>
        </tr>

        <?php form_alternate_row_color( $colors[ "form_alternate1" ], $colors[ "form_alternate2" ], 0 ); ?>
        <td width="50%">
            <font class="textEditTitle">Target URL</font><br>
            The URL of the target
        </td>
        <td>
            <?php form_text_box( "target_url", "", $s_defaultTargetURL, 255 ); ?>
        </td>
        </tr>

        <?php
        if ( $target_id > 0 ) {
            form_hidden_box( "update_component_import", "1", "" );
            form_hidden_box( "target_id", $target_id, "" );
        } else {
            form_hidden_box( "save_component_import", "1", "" );
        }

        html_end_box();
        form_save_button( "CereusTransporter_Targets.php", "save" );

    }

