<?php
	/*******************************************************************************
	 *
	 * File:         $Id: nmid_sp_int_functions.php,v fb418fc897ae 2015/07/17 08:45:46 thurban $
	 * Modified_On:  $Date: 2015/07/17 08:45:46 $
	 * Modified_By:  $Author: thurban $
	 * License:      Commercial
	 * Copyright:    Copyright 2009-2015 by Urban-Software.de / Thomas Urban
	 *******************************************************************************/

	function nmid_sp_display_interface_data( $host_id )
	{
		global $colors;

		$host         = db_fetch_row( "select id,description,hostname,host_template_id from host where id=" . $host_id );
		$row_limit    = 100000;
		$debug_log    = debug_log_return( "new_graphs" );
		$snmp_queries = db_fetch_assoc( "SELECT
						snmp_query.id,
						snmp_query.name,
						snmp_query.xml_path
						FROM (snmp_query,host_snmp_query)
						WHERE host_snmp_query.snmp_query_id=snmp_query.id
						AND host_snmp_query.host_id=" . $host[ "id" ] . " AND snmp_query.id=3
						ORDER BY snmp_query.name" );


		if ( sizeof( $snmp_queries ) > 0 ) {
			foreach ( $snmp_queries as $snmp_query ) {
				unset( $total_rows );
				$page = 1;

				$xml_array = get_data_query_array( $snmp_query[ "id" ] );

				$num_input_fields   = 0;
				$num_visible_fields = 0;

				if ( $xml_array != FALSE ) {
					/* loop through once so we can find out how many input fields there are */
					reset( $xml_array[ "fields" ] );
					while ( list( $field_name, $field_array ) = each( $xml_array[ "fields" ] ) ) {
						if ( $field_array[ "direction" ] == "input" ) {
							$num_input_fields++;

							if ( !isset( $total_rows ) ) {
								$total_rows = db_fetch_cell( "SELECT count(*) FROM host_snmp_cache WHERE host_id=" . $host[ "id" ] . " and snmp_query_id=" . $snmp_query[ "id" ] . " AND field_name='$field_name'" );
							}
						}
					}
				}

				if ( !isset( $total_rows ) ) {
					$total_rows = 0;
				}

				$snmp_query_graphs = db_fetch_assoc( "SELECT snmp_query_graph.id,snmp_query_graph.name FROM snmp_query_graph WHERE snmp_query_graph.snmp_query_id=" . $snmp_query[ "id" ] . " ORDER BY snmp_query_graph.name" );

				if ( sizeof( $snmp_query_graphs ) > 0 ) {
					foreach ( $snmp_query_graphs as $snmp_query_graph ) {
						$created_graphs = db_fetch_assoc( "SELECT DISTINCT
											data_local.snmp_index
											FROM (data_local,data_template_data)
											LEFT JOIN data_input_data ON (data_template_data.id=data_input_data.data_template_data_id)
											LEFT JOIN data_input_fields ON (data_input_data.data_input_field_id=data_input_fields.id)
											WHERE data_local.id=data_template_data.local_data_id
											AND data_input_fields.type_code='output_type'
											AND data_input_data.value='" . $snmp_query_graph[ "id" ] . "'
											AND data_local.host_id=" . $host[ "id" ] );

						$script .= "created_graphs[" . $snmp_query_graph[ "id" ] . "] = new Array(";

						$cg_ctr = 0;
						if ( sizeof( $created_graphs ) > 0 ) {
							foreach ( $created_graphs as $created_graph ) {
								$script .= ( ( $cg_ctr > 0 ) ? "," : "" ) . "'" . encode_data_query_index( $created_graph[ "snmp_index" ] ) . "'";

								$cg_ctr++;
							}
						}

						$script .= ")\n";
					}
				}

				print "	<table width='100%' style='background-color: #" . $colors[ "form_alternate2" ] . "; border: 1px solid #" . $colors[ "header" ] . ";' align='center' cellpadding='3' cellspacing='0'>\n
									<tr>
										<td bgcolor='#" . $colors[ "header" ] . "' colspan='" . ( $num_input_fields + 1 ) . "'>
											<table  cellspacing='0' cellpadding='0' width='100%' >
												<tr>
													<td class='textHeaderDark'>
														<strong>Select the interfaces to monitor for this host [" . $host[ "description" ] . " / ".$host[ "hostname" ]."]
													</td>
													<td align='right' nowrap>

													</td>
												</tr>
											</table>
										</td>
									</tr>";

				if ( $xml_array != FALSE ) {
					$html_dq_header     = "";
					$snmp_query_indexes = array();

					reset( $xml_array[ "fields" ] );

					/* if there is a where clause, get the matching snmp_indexes */
					$sql_where = "";
					if ( strlen( $_REQUEST[ "filter" ] ) ) {
						$sql_where = "";
						$indexes   = db_fetch_assoc( "SELECT DISTINCT snmp_index
											FROM host_snmp_cache
											WHERE field_value LIKE '%%" . $_REQUEST[ "filter" ] . "%%'
											AND snmp_query_id=" . $snmp_query[ "id" ] . "
											AND host_id=" . $host[ "id" ] );

						if ( sizeof( $indexes ) ) {
							foreach ( $indexes as $index ) {
								if ( strlen( $sql_where ) ) {
									$sql_where .= ", '" . $index[ "snmp_index" ] . "'";
								}
								else {
									$sql_where .= " AND snmp_index IN('" . $index[ "snmp_index" ] . "'";
								}
							}

							$sql_where .= ")";
						}
					}

					if ( ( strlen( $_REQUEST[ "filter" ] ) == 0 ) ||
						( ( strlen( $_REQUEST[ "filter" ] ) ) && ( sizeof( $indexes ) ) )
					) {
						/* determine the sort order */
						if ( isset( $xml_array[ "index_order_type" ] ) ) {
							if ( $xml_array[ "index_order_type" ] == "numeric" ) {
								$sql_order = "ORDER BY CAST(snmp_index AS unsigned)";
							}
							else if ( $xml_array[ "index_order_type" ] == "alphabetic" ) {
								$sql_order = "ORDER BY snmp_index";
							}
							else if ( $xml_array[ "index_order_type" ] == "natural" ) {
								$sql_order = "ORDER BY INET_ATON(snmp_index)";
							}
							else {
								$sql_order = "";
							}
						}
						else {
							$sql_order = "";
						}

						/* get the unique field values from the database */
						$field_names = db_fetch_assoc( "SELECT DISTINCT field_name
											FROM host_snmp_cache
											WHERE host_id=" . $host[ "id" ] . "
											AND snmp_query_id=" . $snmp_query[ "id" ] );

						/* build magic query */
						$sql_query          = "SELECT host_id, snmp_query_id, snmp_index";
						$num_visible_fields = sizeof( $field_names );
						$i                  = 0;
						if ( sizeof( $field_names ) > 0 ) {
							foreach ( $field_names as $column ) {
								$field_name = $column[ "field_name" ];
								$sql_query .= ", MAX(CASE WHEN field_name='$field_name' THEN field_value ELSE NULL END) AS '$field_name'";
								$i++;
							}
						}

						$sql_query .= " FROM host_snmp_cache
											WHERE host_id=" . $host[ "id" ] . "
											AND snmp_query_id=" . $snmp_query[ "id" ] . "
											$sql_where
											GROUP BY host_id, snmp_query_id, snmp_index
											$sql_order
											LIMIT " . ( $row_limit * ( $page - 1 ) ) . "," . $row_limit;

						$rows_query = "SELECT host_id, snmp_query_id, snmp_index
											FROM host_snmp_cache
											WHERE host_id=" . $host[ "id" ] . "
											AND snmp_query_id=" . $snmp_query[ "id" ] . "
											$sql_where
											GROUP BY host_id, snmp_query_id, snmp_index";

						$snmp_query_indexes = db_fetch_assoc( $sql_query );

						$total_rows = sizeof( db_fetch_assoc( $rows_query ) );

						if ( ( $page - 1 ) * $row_limit > $total_rows ) {
							$page                                = 1;
							$_REQUEST[ "page" . $query[ "id" ] ] = $page;
							load_current_session_value( "page" . $query[ "id" ], "sess_graphs_new_page" . $query[ "id" ], "1" );
						}

						if ( $total_rows > $row_limit ) {
							/* generate page list */
							$url_page_select = get_page_list( $page, MAX_DISPLAY_PAGES, $row_limit, $total_rows, "graphs_new.php?", "page" . $snmp_query[ "id" ] );

							$nav = "<tr bgcolor='#" . $colors[ "header" ] . "' class='noprint'>
										<td colspan='15'>
											<table width='100%' cellspacing='0' cellpadding='0' border='0'>
												<tr>
													<td align='left' class='textHeaderDark'>
														<strong>&lt;&lt; ";
							if ( $page > 1 ) {
								$nav .= "<a class='linkOverDark' href='" . htmlspecialchars( "graphs_new.php?page" . $snmp_query[ "id" ] . "=" . ( $page - 1 ) ) . "'>";
							}
							$nav .= "Previous";
							if ( $page > 1 ) {
								$nav .= "</a>";
							}
							$nav .= "</strong>
													</td>\n
													<td align='center' class='textHeaderDark'>
														Showing Rows " . ( ( $row_limit * ( $page - 1 ) ) + 1 ) . " to " . ( ( ( $total_rows < $row_limit ) || ( $total_rows < ( $row_limit * $page ) ) ) ? $total_rows : ( $row_limit * $page ) ) . " of $total_rows [$url_page_select]
													</td>\n
													<td align='right' class='textHeaderDark'>
														<strong>";
							if ( ( $page * $row_limit ) < $total_rows ) {
								$nav .= "<a class='linkOverDark' href='" . htmlspecialchars( "graphs_new.php?page" . $snmp_query[ "id" ] . "=" . ( $page + 1 ) ) . "'>";
							}
							$nav .= "Next";
							if ( ( $page * $row_limit ) < $total_rows ) {
								$nav .= "</a>";
							}
							$nav .= " &gt;&gt;</strong>
													</td>\n
												</tr>
											</table>
										</td>
									</tr>\n";

							print $nav;
						}

						while ( list( $field_name, $field_array ) = each( $xml_array[ "fields" ] ) ) {
							if ( $field_array[ "direction" ] == "input" && sizeof( $field_names ) ) {
								foreach ( $field_names as $row ) {
									if ( $row[ "field_name" ] == $field_name ) {
										$html_dq_header .= "<td style='height:1px;'><strong><font color='#" . $colors[ "header_text" ] . "'>" . $field_array[ "name" ] . "</font></strong></td>\n";
										break;
									}
								}
							}
						}

						if ( !sizeof( $snmp_query_indexes ) ) {
							print "<tr bgcolor='#" . $colors[ "form_alternate1" ] . "'><td>This data query returned 0 rows, perhaps there was a problem executing this
												data query. You can <a href='" . htmlspecialchars( "host.php?action=query_verbose&id=" . $snmp_query[ "id" ] . "&host_id=" . $host[ "id" ] ) . "'>run this data
												query in debug mode</a> to get more information.</td></tr>\n";
						}
						else {
							print "	<tr bgcolor='#" . $colors[ "header_panel" ] . "'>
									$html_dq_header
									<td></td>
								</tr>\n";
						}

						$row_counter    = 0;
						$column_counter = 0;
						$fields         = array_rekey( $field_names, "field_name", "field_name" );
						if ( sizeof( $snmp_query_indexes ) > 0 ) {
							foreach ( $snmp_query_indexes as $row ) {
								$query_row = $snmp_query[ "id" ] . "_" . encode_data_query_index( $row[ "snmp_index" ] );

								print "<tr id='line$query_row' bgcolor='#" . ( ( $row_counter % 2 == 0 ) ? "ffffff" : $colors[ "light" ] ) . "'>";
								$i++;

								$column_counter = 0;
								reset( $xml_array[ "fields" ] );
								while ( list( $field_name, $field_array ) = each( $xml_array[ "fields" ] ) ) {
									if ( $field_array[ "direction" ] == "input" ) {
										if ( in_array( $field_name, $fields ) ) {
											if ( isset( $row[ $field_name ] ) ) {
												print "<td><span id='text$query_row" . "_" . $column_counter . "'>" . ( strlen( $_REQUEST[ "filter" ] ) ? preg_replace( "/(" . preg_quote( $_REQUEST[ "filter" ] ) . ")/i", "<span style='background-color: #F8D93D;'>\\1</span>", $row[ $field_name ] ) : $row[ $field_name ] ) . "</span></td>";
											}
											else {
												print "<td><span id='text$query_row" . "_" . $column_counter . "'></span></td>";
											}

											$column_counter++;
										}
									}
								}
								$nmid_data_value = $row[ 'ifDescr' ] . '@'.$row[ 'ifName' ] . '@'.$row[ 'ifAlias' ] . '@'.$row[ 'ifIP' ] ;
								print "<td align='right'>";
								print "<input type='checkbox' name='sg_int[]' id='sg_int[]' value='".$nmid_data_value."'/>";
								print "</td>";
								print "</tr>\n";

								$row_counter++;
							}
						}

						if ( $total_rows > $row_limit ) {
							print $nav;
						}
					}
					else {
						print "<tr bgcolor='#" . $colors[ "form_alternate1" ] . "'><td colspan='2' style='color: red; font-size: 12px; font-weight: bold;'>Search Returned no Rows.</td></tr>\n";
					}
				}
				else {
					print "<tr bgcolor='#" . $colors[ "form_alternate1" ] . "'><td colspan='2' style='color: red; font-size: 12px; font-weight: bold;'>Error in data query.</td></tr>\n";
				}

				print "</table>";

				/* draw the graph template drop down here */
				$data_query_graphs = db_fetch_assoc( "select snmp_query_graph.id,snmp_query_graph.name from snmp_query_graph where snmp_query_graph.snmp_query_id=" . $snmp_query[ "id" ] . " order by snmp_query_graph.name" );

				if ( sizeof( $data_query_graphs ) == 1 ) {
					echo "<input type='hidden' id='sgg_" . $snmp_query[ "id" ] . "' name='sgg_" . $snmp_query[ "id" ] . "' value='" . $data_query_graphs[ 0 ][ "id" ] . "'>\n";
				}
				elseif ( sizeof( $data_query_graphs ) > 1 ) {
					print "	<table align='center' width='100%'>
							<tr>
								<td width='1' valign='top'>
									<img src='images/arrow.gif' alt=''>&nbsp;
								</td>
								<td align='right'>
									<!-- Add submit button here -->

										<input type=submit value='Continue'>
								</td>
							</tr>
						</table>";
				}

				print "<br>";

				$script .= "dq_update_deps(" . $snmp_query[ "id" ] . "," . $num_visible_fields . ");\n";
			}
		}
	}


	function nmid_sp_isNewCactiUI()
	{
		global $config;
		// get minor and major version number
		preg_match( "@(\d+)\.(\d+).(\d+)(\w+)@", $config[ "cacti_version" ], $version_match );

		$version_major        = $version_match[ 1 ];
		$version_minor        = $version_match[ 2 ];
		$version_build        = $version_match[ 3 ];
		$version_build_mintor = $version_match[ 4 ];

		if ( $version_major < 1 ) {  // 0.
			if ( $version_minor < 9 ) {  // 0.8
				if ( $version_build < 8 ) { // 0.8.7
					return FALSE;
				}
				else {  // 0.8.8
					if ( ord( $version_build_mintor ) < 99 ) { // 0.8.8a 0.8.8b
						return FALSE;
					}
				}
			}
		}
		// 0.8.8c and greater
		return TRUE;

	}

	function nmid_sp_page_buttons( $args )
	{
		global $config, $colors, $plugin_architecture, $CR_Create_Dialog_Text, $CR_Add_Dialog_Text;



		if ( api_user_realm_auth( 'getSmokePingImage.php' ) ) {
			$mode = $_REQUEST[ 'action' ];
			if ( $mode == 'tree_content' ) {
				if ( nmid_sp_isNewCactiUI() ) {
					$tree_id = $_REQUEST[ 'tree_id' ];
					$leaf_id = $_REQUEST[ 'leaf_id' ];
				}
				else {
					$tree_id = $args[ 'treeid' ];
					$leaf_id = $args[ 'leafid' ];
				}
			}
			elseif ( $mode == 'mrtg' ) {
				return;
			}

			$intid = -1;
			if ( isset ($_SESSION["nmidInterface"]) ) {
				$intid = $_SESSION["nmidInterface"];
			}
			echo "<table width=99%><tr><td>&nbsp;</td><td align=right>";

			if ( $mode == 'tree_content' ) {
				//if ( nmidSmokeping_readPluginStatus( 'nmidskin' ) ) {
				//}
				//else {

				$orderKey = db_fetch_assoc( 'select order_key from graph_tree_items where id='.$leaf_id.';' );
				$orderKey = preg_replace("/(0{3,3})+$/","",$orderKey[0]["order_key"]);
				$host_id = db_fetch_assoc("select host_id from graph_tree_items where graph_tree_id='".$tree_id."' AND order_key like '".$orderKey."000%';");
				$host_id = $host_id[0]['host_id'];
				$interface_list = db_fetch_assoc( "select * from plugin_nmidSmokeping_interface_list where host_id=".	$host_id);
				if ( sizeof($interface_list ) > 0 ) {
					?>
					<form method="get">
					<select name="interface">
						<option value="-1">Please select an interface</option>
						<option value="0" <?php if ($intid == 0) {echo "selected";}?>>Show All</option>
						<?php

							foreach ( $interface_list as $interface ) {
								$selected = '';
								if ($intid == $interface[ "int_id" ]) {
									$selected = "selected";
								}
								echo "<option value='" . $interface[ "int_id" ] . "' $selected>" . $interface[ "interface_ip" ] . ' ( ' . $interface[ "interface_description" ] . ' ) -  ( ' . $interface[ "interface_alias" ] . " )</option>";
							}
						?>
					</select>
					<input title='Go' type='image' id='nmidOpener' src='<?php echo $config[ 'url_path' ]; ?>images/button_go.gif'/>
					</form>
				<?php
				}
				//if ( nmid_sp_isNewCactiUI() ) {
				//}
				//else {
					//echo "<input title='Add graphs to report' type='image' id='nmidOpener' src='plugins/CereusReporting/images/Report_Add.png'/>";
					//echo "<input title='Create PDF Report'  type='image' src='plugins/CereusReporting/images/PDF_file.png' id='nmidCreateOpener' value='DefaultType' alt='DefaultType'>";
				//}
				//}
			}
			echo "</td></tr></table>\n";
		}
	}