<?php
/*******************************************************************************
 * 
 * File:         $Id: nmid_sp_manage_interfaces.php,v fb418fc897ae 2015/07/17 08:45:46 thurban $
 * Modified_On:  $Date: 2015/07/17 08:45:46 $
 * Modified_By:  $Author: thurban $ 
 * License:      Commercial
 * Copyright:    Copyright 2009-2015 by Urban-Software.de / Thomas Urban
 
*******************************************************************************/
	$dir     = dirname( __FILE__ );
	$mainDir = preg_replace( "@plugins.nmidSmokeping@", "", $dir );
	chdir( $mainDir );

	include_once( $dir . '/include/nmid_sp_int_setup.php' );
	include_once("./include/auth.php");

	$int_data = $_REQUEST['sg_int'];
	$host_id = $_REQUEST['nmid_hostid'];


	/* set default action */
	if (!isset($_REQUEST["action"])) { $_REQUEST["action"] = ""; }
	if (!isset($_REQUEST["drp_action"])) { $_REQUEST["drp_action"] = ""; }

	switch ($_REQUEST["action"]) {
		case 'actions':
			form_save($host_id, $int_data, $_REQUEST["drp_action"]);
			break;
		default:
			include_once("./include/top_header.php");
			form_display($host_id, $int_data);
			include_once("./include/bottom_footer.php");
			break;
	}

	function form_save($host_id, $int_data, $sp_server_number) {
		global $config;
		if ( isset( $int_data ) ) {
			foreach ( $int_data as $key => $name ) {
				/* ================= input validation ================= */
				input_validate_input_number( $host_id );
				/* ==================================================== */

				$data = preg_split( '/@/', $name );

				$already_added = db_fetch_cell( "select interface_ip from plugin_nmidSmokeping_interface_list where host_id=" . $host_id . ' AND  smokepin_server = "'.read_config_option( "nmid_spserver" . $sp_server_number ).'" AND interface_ip="'.$data[3].'"' );
				if ( strlen($already_added) > 0 ) {
					db_execute( "UPDATE plugin_nmidSmokeping_interface_list SET ".
					            ' interface_description = "'. $data[ 0 ].'",'.
					            ' interface_name = "'. $data[ 1 ].'",'.
					            ' interface_alias = "'. $data[ 2 ].'",'.
					            ' smokepin_server = "'.read_config_option( "nmid_spserver" . $sp_server_number ).'",'.
					            ' WHERE host_id=' . $host_id .
					            ' AND interface_ip="' . $data[ 3 ].'"' );
				} else {
					db_execute( 'INSERT INTO plugin_nmidSmokeping_interface_list (`interface_description`,`interface_name`,`interface_alias`,`smokepin_server`,`host_id`,`interface_ip`)
								 VALUES (
								 	"'. $data[ 0 ].'","'. $data[ 1 ].'","'. $data[ 2 ].'","'. read_config_option( "nmid_spserver" . $sp_server_number ).'",'. $host_id.',"'. $data[ 3 ].'"
								 )');
				}
			}
		}
		nmidSmokeping_configCreate();

		header("Location: ".$config[ 'url_path' ]."host.php");
		exit;
	}

	function form_display( $host_id, $int_data )
	{
		global $config, $$colors;

		$display_text = array(
			"description" => array("Description", "ASC"),
			"name" => array("Name", "ASC"),
			"alias" => array("Alias", "ASC"),
			"ipaddress" => array("IP Address", "ASC"));

		html_start_box("Add Interfaces to Smokpeing", "100%", $colors["header"], "3", "center", "");

		html_header_sort($display_text, get_request_var_request("sort_column"), get_request_var_request("sort_direction"), false);
		$i = 0;
		foreach ( $int_data as $key => $name ) {
			$data = preg_split( '/@/', $name );
			form_alternate_row_color($colors["alternate"], $colors["light"], $i, 'line' . 0); $i++;
			form_selectable_cell($data[ 0 ], $i);
			form_selectable_cell($data[ 1 ], $i);
			form_selectable_cell($data[ 2 ], $i);
			form_selectable_cell($data[ 3 ], $i);
			form_end_row();
		}


		$nmid_sp_type = '';
		if ( read_config_option( 'nmid_sp_mode' ) == 'slave' ) {
			$nmid_sp_type = 'Slave';
		}
		$device_actions = array(
			1 => "Add to Smokeping $nmid_sp_type (" . read_config_option( "nmid_spserver1" ) . ")",
			2 => "Add to Smokeping $nmid_sp_type (" . read_config_option( "nmid_spserver2" ) . ")",
			3 => "Add to Smokeping $nmid_sp_type (" . read_config_option( "nmid_spserver3" ) . ")",
			4 => "Add to Smokeping $nmid_sp_type (" . read_config_option( "nmid_spserver4" ) . ")"
		);

		html_end_box(false);
		print '<form method="post" action="'.$config[ 'url_path' ].'plugins/nmidSmokeping/nmid_sp_manage_interfaces.php">';
		print "<input type='hidden' name='nmid_hostid' value='$host_id'>";
		foreach ( $int_data as $key => $name ) {
			print "<input type='hidden' name='sg_int[]' value='$name'>";

		}

		draw_actions_dropdown($device_actions);
		print "</form>";
				/*
		 * Add functionality to manage interfaces
		 * -> Display Selected Interfaces
		 * -> Confirm selection
		 * -> Select Smokeping server to add interfaces to
		 */
	}

